#!/bin/sh

# Sample shell script for gnuplot
# Make executable files and run the following command:
#
# > ./gunplot.sh
#


# Check that the utility is present.

type gnuplot >/dev/null 2>&1 || { echo >&2 "You need gnuplot to run the script. Aborting."; exit 1; }


# Run test programs.

srcdir="../test"
$srcdir/test1 $srcdir/testmat.mtx 1 /dev/null "ILU0-BiCG" -i bicg -p ilu
$srcdir/test1 $srcdir/testmat.mtx 1 /dev/null "ILU0-CGS" -i cgs -p ilu
$srcdir/test1 $srcdir/testmat.mtx 1 /dev/null "ILU0-BiCGSTAB" -i bicgstab -p ilu


# Draw residual history using gnuplot.

gnuplot gnuplot.plt

rm ILU0-*

